<?php

namespace Redtree\Tenancy\Listeners;

use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Contracts\Filesystem\Factory;
use Illuminate\Support\Facades\Storage;
use Redtree\Tenancy\Events\TenantSwitched;

class ActivatesDisk
{
    protected Factory $filesystem;

    public function __construct(Factory $filesystem)
    {
        $this->filesystem = $filesystem;
    }

    public function subscribe(Dispatcher $events)
    {
        $events->listen(TenantSwitched::class, [$this, 'activate']);
    }

    public function activate(TenantSwitched $event)
    {
        if ($event->tenant !== null) {
            $disk = config('tenancy.disk') ?? 'local';
            config(['filesystems.disks.tenant' => config('filesystems.disks.' . $disk)]);

            $this->filesystem->set('tenant', null);

            $prefix = Storage::disk('tenant')
                ->getAdapter()
                ->getPathPrefix();

            Storage::disk('tenant')
                ->getAdapter()
                ->setPathPrefix(sprintf('%stenancy/tenants/%s', $prefix, $event->tenant->uuid));
        }
    }
}
