<?php

namespace Redtree\Tenancy\Models\System;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Redtree\Tenancy\Traits\UsesSystemConnection;

class App extends Model
{
    use UsesSystemConnection;

    protected $fillable = [
        'name',
        'url',
        'type',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'bool',
    ];

    /**
     * @return BelongsToMany|Tenant
     */
    public function tenants(): BelongsToMany
    {
        return $this->belongsToMany(Tenant::class)
            ->using(AppTenantPivot::class)
            ->withPivot(['url']);
    }

    /**
     * @return BelongsToMany|User
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class)
            ->using(AppUserPivot::class)
            ->withPivot(['tenant_id']);
    }

    public function scopeActive(Builder $builder): Builder
    {
        return $builder->where('is_active', true);
    }

    /**
     * @deprecated
     */
    public function scopeIsActive(Builder $builder): Builder
    {
        return $builder->where('is_active', true);
    }
}
