<?php

namespace Redtree\Tenancy\Models\System;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Redtree\Tenancy\Traits\UsesSystemConnection;

class AppUserPivot extends Pivot
{
    use UsesSystemConnection;

    protected $table = 'app_user';

    /**
     * @return BelongsTo|App
     */
    public function app(): BelongsTo
    {
        return $this->belongsTo(App::class);
    }

    /**
     * @return BelongsTo|User
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return BelongsTo|Tenant
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }
}
