<?php

namespace Redtree\Tenancy\Models\System;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Redtree\Tenancy\Traits\UsesSystemConnection;

class DeployCommand extends Model
{
    use UsesSystemConnection;

    public $fillable = [
        'app_name',
    ];

    /**
     * @return BelongsTo|Tenant
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }
}
