<?php

namespace Redtree\Tenancy\Models\System;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Redtree\Tenancy\Models\Tenant\Role;
use Redtree\Tenancy\Traits\HasUuid;
use Redtree\Tenancy\Traits\UsesSystemConnection;

class Group extends Model
{
    use UsesSystemConnection;
    use HasUuid;

    protected $fillable = [
        'uuid',
        'name',
    ];

    /**
     * @return BelongsTo|Tenant
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * @return BelongsToMany|User
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }

    /**
     * @return BelongsToMany|Role
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class);
    }

    /**
     * @return BelongsToMany|App
     */
    public function apps(): BelongsToMany
    {
        return $this->belongsToMany(App::class);
    }
}
