<?php

namespace Redtree\Tenancy\Models\Tenant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Redtree\FileLibrary\HasMedia;
use Redtree\FileLibrary\InteractsWithMedia;
use Redtree\FileLibrary\Media\Models\Media;
use Redtree\Tenancy\Traits\HasUuid;
use Redtree\Tenancy\Traits\UsesTenantConnection;

class Brand extends Model implements HasMedia
{
    use UsesTenantConnection;
    use HasUuid;
    use InteractsWithMedia;

    protected $fillable = [
        'name',
        'is_default',
        'version',
    ];

    protected $casts = [
        'is_default' => 'bool',
    ];

    /**
     * @return MorphMany|BrandRevision
     */
    public function revisions(): MorphMany
    {
        return $this->morphMany(BrandRevision::class, 'revisionable');
    }

    /**
     * @return MorphOne|BrandRevision
     */
    public function lastRevision(): MorphOne
    {
        return $this->morphOne(BrandRevision::class, 'revisionable')
            ->latest()
            ->limit(1);
    }

    public function registerMediaConversions(Media $media = null): void
    {
        $sizes = [36, 48, 57, 60, 72, 96, 114, 120, 144, 150, 152, 180, 192, 310];

        foreach ($sizes as $size) {
            $this
                ->addMediaConversion($size)
                ->width($size)
                ->height($size)
                ->format('png')
                ->performOnCollections('favicon');
        }
    }

    public function registerMediaCollections(): void
    {
        $collections = ['login', 'register', 'password-reset', 'invite', 'topsection', 'favicon', 'favicon.ico', 'logout', 'error404', 'error500', 'center-dashboard'];

        foreach ($collections as $collection) {
            $this->addMediaCollection($collection)->singleFile();
        }
    }
}
