<?php

namespace Redtree\Tenancy\Models\Tenant;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Redtree\Tenancy\Traits\UsesTenantConnection;

class BrandRevision extends Revision
{
    use UsesTenantConnection;

    /**
     * @return BelongsTo|Brand
     */
    public function brand(): BelongsTo
    {
        return $this->belongsTo(model_class(Brand::class));
    }
}
