<?php

namespace Redtree\Tenancy\Models\Tenant;

use Illuminate\Database\Eloquent\Casts\AsArrayObject;
use Illuminate\Database\Eloquent\Model;
use Redtree\Tenancy\Traits\UsesTenantConnection;

class Log extends Model
{
    use UsesTenantConnection;

    protected $fillable = [
        'app',
        'uuid',
        'name',
        'data',
    ];

    protected $casts = [
        'data' => AsArrayObject::class,
    ];
}
