<?php

namespace Redtree\Tenancy\Models\Tenant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Redtree\Tenancy\Traits\UsesTenantConnection;

class Revision extends Model
{
    use UsesTenantConnection;

    protected $table = 'revisions';

    protected $fillable = [
        'data',
    ];

    protected $casts = [
        'data' => 'json',
    ];

    public function revisionable(): MorphTo
    {
        return $this->morphTo();
    }
}
