<?php

namespace Redtree\Tenancy\Models\Tenant;

use Illuminate\Database\Eloquent\Model;
use Redtree\Tenancy\Traits\UsesTenantConnection;

class Setting extends Model
{
    use UsesTenantConnection;

    protected $fillable = [
        'key',
        'value',
        'json',
    ];

    protected $casts = [
        'json' => 'array',
    ];

    public function setValueAttribute($value): void
    {
        if ($value !== null) {
            $this->attributes['value'] = serialize($value);
        }
    }

    public function getValueAttribute($value)
    {
        return unserialize($value);
    }
}
