<?php

namespace Redtree\Tenancy\Services\Actions;

use Illuminate\Contracts\Support\Arrayable;

class Action implements Arrayable
{
    protected string $route = '';
    protected string $function = '';
    protected string $method = 'get';
    protected string $label = '';
    protected string $labelColorClass = '';
    protected string $type = '';
    protected bool $needsConfirmation = false;
    protected ?string $confirmationText = null;

    public function __construct()
    {
        if (method_exists($this, 'init')) {
            $this->init();
        }
    }

    public function setRoute(string $route): self
    {
        $this->route = $route;

        return $this;
    }

    public function setFunction(string $function): self
    {
        $this->function = $function;

        return $this;
    }

    public function setMethod(string $method): self
    {
        if (in_array($method, ['get', 'post', 'put', 'patch', 'delete'])) {
            $this->method = $method;
        }

        return $this;
    }

    public function setLabel(string $label, string $colorClass = 'body'): self
    {
        $this->label = $label;
        $this->labelColorClass = $colorClass;

        return $this;
    }

    public function setType(string $type): self
    {
        if (in_array($type, ['http', 'xhr', 'modal'])) {
            $this->type = $type;
        }

        return $this;
    }

    public function hasConfirmation(string $text): self
    {
        $this->needsConfirmation = true;
        $this->confirmationText = $text;

        return $this;
    }

    public function toArray(): array
    {
        $data = [];

        if (method_exists($this, 'data')) {
            $data = $this->data();
        }

        return array_merge($data, [
            'route' => $this->route,
            'action' => $this->method,
            'method' => $this->function,
            'label' => $this->label,
            'labelColorClass' => $this->labelColorClass,
            'type' => $this->type,
            'needsConfirmation' => $this->needsConfirmation,
            'confirmationText' => $this->confirmationText,
        ]);
    }
}
