<?php

namespace Redtree\Tenancy\Services\Actions;

class EditAction extends Action
{
    protected string $updateRoute = '';
    protected string $updateMethod = 'post';

    public function init(): void
    {
        $this->type = 'modal';
    }

    public function setUpdateRoute(string $route): self
    {
        $this->updateRoute = $route;

        return $this;
    }

    public function setUpdateMethod(string $method): self
    {
        if (in_array($method, ['get', 'post', 'put', 'patch', 'delete'])) {
            $this->updateMethod = $method;
        }

        return $this;
    }

    public function data(): array
    {
        return [
            'update' => [
                'route' => $this->updateRoute,
                'action' => $this->updateMethod,
            ],
        ];
    }
}
