<?php

namespace Redtree\Tenancy\Services;

use Illuminate\Support\Collection;
use Illuminate\Support\Traits\Conditionable;
use Redtree\Tenancy\Services\Actions\Action;

class ActionsService
{
    use Conditionable;

    protected Collection $actions;

    public function __construct()
    {
        $this->actions = collect();
    }

    public function addAction(Action $action): self
    {
        $this->actions->push($action);

        return $this;
    }

    /**
     * @deprecated
     */
    public function addActionWhen(bool $condition, Action $action): self
    {
        if (! $condition) {
            return $this;
        }

        return $this->addAction($action);
    }

    public function toArray(): array
    {
        return  $this->actions->toArray();
    }
}
