<?php

namespace Redtree\Tenancy\Services;

use Illuminate\Support\Str;
use Redtree\Tenancy\Models\Tenant\Log;

class LoggingService
{
    protected bool $useLastUuid = false;

    protected ?string $uuid = null;

    public function useLastUuid(): self
    {
        $this->useLastUuid = true;

        return $this;
    }

    public function create(string $name, array $data): void
    {
        $this->uuid = $this->useLastUuid ? $this->uuid : null;

        Log::create([
            'app' => 'center',
            'uuid' => $this->uuid ?? (string) Str::uuid(),
            'name' => $name,
            'data' => $data,
        ]);

        $this->useLastUuid = false;
    }
}
