<?php

namespace Redtree\Tenancy\Services;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Redtree\Tenancy\Models\Tenant\Menu;

class MenuService
{
    protected array $menus = [];

    public static array $conditions = [];

    public function __construct()
    {
        self::addCondition('setting', function (array $options) {
            $value = settings()->getJsonValue($options['key'], $options['path']);

            if ($value === null || ! $this->parseConditionOptionOperations($options['operation'], $options['value'], $value)) {
                return false;
            }

            return true;
        });
    }

    public static function addCondition(string $key, callable $func): void
    {
        self::$conditions[$key] = $func;
    }

    public function get(string $key, string $app = null): array
    {
        if (current_tenant() === null) {
            return [];
        }

        if ($app === null) {
            $app = config('tenancy.app_name');
        }

        if (! isset($this->menus[$app][$key])) {
            if ($app === config('tenancy.app_name')) {
                $menu = Arr::get(config('menus'), $key);
            } else {
                $menu = optional(Menu::where('app', $app)->where('key', $key)->first())->menu;
            }

            $this->menus[$app][$key] = $this->parseRoutes($this->parseConditions($menu ?? []));
        }

        return $this->menus[$app][$key] ?? [];
    }

    public function parseConditionOptionOperations(string $operation, $value1, $value2): bool
    {
        switch ($operation) {
            case 'equals':
                return $value1 == $value2;
            case 'equalsStrict':
                return $value1 === $value2;
        }

        return false;
    }

    protected function parseConditions(array $menu): array
    {
        foreach ($menu as $key => $item) {
            if (Arr::has($item, 'conditions')) {
                foreach (Arr::get($item, 'conditions') as $condition => $options) {
                    if (! is_array($options)) {
                        $condition = $options;
                    }

                    if (isset(self::$conditions[$condition])) {
                        if (self::$conditions[$condition]($options)) {
                            continue;
                        }
                    }

                    unset($menu[$key]);
                }
            }
        }

        return $menu;
    }

    protected function parseRoutes(array $menu): array
    {
        $tmp = [];

        collect(Arr::dot($menu))->each(function ($value, $key) use (&$tmp) {
            if (Str::endsWith($key, '.route')) {
                $key = Str::replaceLast('.route', '.url', $key);
                $value = route($value);
            }

            Arr::set($tmp, $key, $value);
        });

        return $tmp;
    }
}
