<?php

namespace Redtree\Tenancy\Services;

use Illuminate\Support\Arr;

class ModelClassService
{
    protected array $modelClasses = [];

    public function __construct()
    {
        $this->modelClasses = config()->get('tenancy.model_classes');
    }

    public function getModelClass(string $class): string
    {
        if (isset($this->modelClasses[$class]) && Arr::first(class_parents($class)) === $this->modelClasses[$class]) {
            return $this->modelClasses[$class];
        }

        return $class;
    }
}
