<?php

namespace Redtree\Tenancy\Services;

use Carbon\CarbonImmutable;
use Illuminate\Contracts\Cache\Repository;
use Illuminate\Support\Collection;
use Redtree\Tenancy\Models\Tenant\Permission;

class PermissionsCache
{
    public static string $cacheKey = 'permissions.cache';

    /** @var CarbonImmutable */
    public static $cacheExpirationTime;

    protected Repository $cache;

    protected ?Collection $permissions = null;

    public function __construct()
    {
        self::$cacheExpirationTime = now()->addHours(24);

        $this->cache = cache()->store();
    }

    public function forgetCachedPermissions(): bool
    {
        $this->permissions = null;

        return $this->cache->forget(self::getCacheKey());
    }

    public function getPermissions(array $params = []): Collection
    {
        if ($this->permissions === null) {
            $this->permissions = $this->cache
                ->remember(self::getCacheKey(), self::$cacheExpirationTime, static function () {
                    return Permission::with('roles')->get();
                });
        }

        $permissions = clone $this->permissions;

        foreach ($params as $attr => $value) {
            $permissions = $permissions->where($attr, $value);
        }

        return $permissions;
    }

    public static function getCacheKey(): string
    {
        if (current_tenant() !== null) {
            return self::$cacheKey . '.' . current_tenant()->uuid;
        }

        return self::$cacheKey;
    }
}
