<?php

namespace Redtree\Tenancy\Services;

use Illuminate\Support\Arr;
use Redtree\Tenancy\Models\Tenant\Setting;

class SettingsService
{
    protected array $settingsCache = [];

    public function get(string $key): Setting
    {
        if (! isset($this->settingsCache[$key])) {
            $this->settingsCache[$key] = Setting::where('key', $key)->firstOrNew();
        }

        return $this->settingsCache[$key];
    }

    public function getValue(string $key, $default = null)
    {
        return $this->get($key)->value ?? $default;
    }

    public function getJson(string $key): array
    {
        return $this->get($key)->json ?? [];
    }

    public function getJsonValue(string $key, string $value, $default = null)
    {
        return Arr::get($this->getJson($key), $value, $default);
    }

    public function getAsDTO(string $key, string $class)
    {
        return new $class($this->getJson($key));
    }

    public function set(string $key, $value = null, $json = null): void
    {
        $setting = Setting::updateOrCreate([
            'key' => $key,
        ], [
            'value' => $value,
            'json' => $json,
        ]);

        $this->settingsCache[$key] = $setting;
    }

    public function setValue(string $key, $value): void
    {
        $this->set($key, $value);
    }

    public function setJson(string $key, $json): void
    {
        $this->set($key, null, $json);
    }

    public function flush(): void
    {
        $this->settingsCache = [];
    }
}
