<?php

namespace Redtree\Tenancy\Traits;

use Illuminate\Database\Eloquent\Builder;

trait Searchable
{
    public function scopeSearch(Builder $builder, ?string $search): Builder
    {
        if ($search === null) {
            return $builder;
        }

        $fields = $this->searchable ?? $this->fillable ?? [];

        return $builder
            ->when(! empty($fields), function (Builder $builder) use (&$fields, &$search) {
                $builder
                    ->where(function (Builder $builder) use (&$fields, &$search) {
                        foreach ($fields as $field) {
                            $builder->orWhere($field, 'like', "%$search%");
                        }
                    });
            });
    }
}
