<?php

namespace Redtree\Tenancy\Traits;

use Illuminate\Database\Eloquent\Model;
use Redtree\Tenancy\Scopes\AppNameScope;

trait WithAppName
{
    protected static function bootWithAppName(): void
    {
        static::addGlobalScope(new AppNameScope());

        static::saving(function (Model $model) {
            $model->app_name = config('tenancy.app_name');
        });
    }
}
