<?php

use Illuminate\Support\Str;

it('has helper functions', function () {
    expect(function_exists('current_tenant'))->toBeTrue();
    expect(function_exists('settings'))->toBeTrue();
    expect(function_exists('iolog'))->toBeTrue();
    expect(function_exists('base_url'))->toBeTrue();
    expect(function_exists('current_user'))->toBeTrue();
    expect(function_exists('io_encrypt'))->toBeTrue();
    expect(function_exists('io_decrypt'))->toBeTrue();
    expect(function_exists('saml_certificate'))->toBeTrue();
    expect(function_exists('actions'))->toBeTrue();
    expect(function_exists('baseAction'))->toBeTrue();
    expect(function_exists('editAction'))->toBeTrue();
    expect(function_exists('current_brand'))->toBeTrue();
    expect(function_exists('asset_version'))->toBeTrue();
    expect(function_exists('current_tenant_stylesheet_url'))->toBeTrue();
    expect(function_exists('current_tenant_scripts_url'))->toBeTrue();
    expect(function_exists('current_tenant_favicon_url'))->toBeTrue();
});

it('returns the same object', function () {
    expect(settings())->tobe(settings());
    expect(iolog())->tobe(iolog());
});

it('can encrypt and decrypt', function () {
    config()->set('tenancy.crypt.iv', Str::random());

    $encrypted = io_encrypt('Test String', 'test');

    expect(io_decrypt($encrypted, 'test'))->toBe('Test String');
});

it('returns base url', function () {
    expect(base_url('https://google.de/test1'))->toBe('https://google.de');
    expect(base_url('google.de/test2'))->toBe('https://google.de');
    expect(base_url('http://google.de/test3'))->toBe('https://google.de');
    expect(base_url('http://google.de/test4', 'http'))->toBe('http://google.de');
    expect(base_url('https://google.de/test5', 'http'))->toBe('http://google.de');
    expect(base_url('google.de/test5', 'http'))->toBe('http://google.de');
});

it('returns certificate', function () {
    $cert = '-----BEGIN CERTIFICATE-----MIICVDCCAb2gAwIBAgIBADANBgkqhkiG9w0BAQ0FADBHMQswCQYDVQQGEwJkZTEM7jevbaBIU-----END CERTIFICATE-----';

    expect(saml_certificate($cert))->toBe($cert);
    expect(saml_certificate(__DIR__ . '/cert.pem'))->toStartWith($cert);
});

it('can create actions', function () {
    expect(actions()
        ->addAction(baseAction()
            ->setLabel('Test')
            ->setRoute('https://google.de')
            ->setMethod('get')
            ->setType('http')
            ->setFunction('test')
            ->hasConfirmation('Test Text')
        )
        ->toArray()
    )
        ->toBe([
            [
                'route' => 'https://google.de',
                'action' => 'get',
                'method' => 'test',
                'label' => 'Test',
                'labelColorClass' => 'body',
                'type' => 'http',
                'needsConfirmation' => true,
                'confirmationText' => 'Test Text',
            ]
        ]);

    expect(actions()
        ->addAction(editAction()
            ->setLabel('Edit Test')
            ->setRoute('https://google.de')
            ->setMethod('post')
            ->setType('http')
            ->setFunction('test')
            ->hasConfirmation('Test Text')
            ->setUpdateMethod('patch')
            ->setUpdateRoute('https://google.de/edit')
        )
        ->toArray()
    )
        ->toBe([
            [
                'update' => [
                    'route' => 'https://google.de/edit',
                    'action' => 'patch',
                ],
                'route' => 'https://google.de',
                'action' => 'post',
                'method' => 'test',
                'label' => 'Edit Test',
                'labelColorClass' => 'body',
                'type' => 'http',
                'needsConfirmation' => true,
                'confirmationText' => 'Test Text',
            ]
        ]);
});
