<?php

namespace Redtree\IoSuiteBase\Middlewares;

use BadFunctionCallException;
use Closure;
use RuntimeException;
use Throwable;

class BaseUserAuthenticated
{
    /**
     * @param $request
     * @param  Closure  $next
     * @throws Throwable
     */
    public function handle($request, Closure $next)
    {
        throw_if(! function_exists('current_user'), new BadFunctionCallException('Missing method current_user'));

        if (! class_exists(\App\Models\System\User::class)) {
            throw new RuntimeException('Missing User Class');
        }
        $user = current_user();
        if ($user instanceof \App\Models\System\User) {
            if (! $user->is_logged_in) {
                $request->session()->invalidate();
                $request->session()->regenerateToken();

                return redirect()->to(config('saml.idp.singleSignOnService.url'));
            }
        }

        return $next($request);
    }
}
